function output_fold = myfun_SVM_TrTe_PAR(input_fold)

tbfolder = [cd  filesep 'AR_Toolboxes_and_functions'];
addpath(tbfolder , ...
    [tbfolder  filesep 'libsvm-3.1' filesep 'matlab'], ...
    [tbfolder  filesep 'libsvm-3.1' filesep 'matlab' filesep '64bit'], ...
    [tbfolder  filesep 'PRToolsMatlab' filesep 'prtools'],...
    [tbfolder  filesep 'libsvm-3.1' filesep 'tools'] );

TS_label = input_fold.TS_label;
TS_inst_sc = input_fold.TS_inst_sc;
VS_label = input_fold.VS_label;
VS_inst_sc = input_fold.VS_inst_sc;
kernel = input_fold.kernel;
C = input_fold.C;
gamma = input_fold.gamma;
Pb = input_fold.Pb;
termination = input_fold.termination;

%% train and test
if(Pb)
    if ~isempty(termination)
        model = svmtrain(TS_label, TS_inst_sc, [' -t ' num2str(kernel)  ' -c ' num2str(C, '%12.12f') ' -g ' num2str(gamma, '%12.12f') ' -b ' num2str(Pb) ' -e ' num2str(termination, '%12.12f') ]);
    else
        model = svmtrain(TS_label, TS_inst_sc, [' -t ' num2str(kernel)  ' -c ' num2str(C, '%12.12f') ' -g ' num2str(gamma, '%12.12f') ' -b ' num2str(Pb) ]);
    end
    [predict, accuracy(:,1), prob_tmp] = svmpredict(VS_label, VS_inst_sc, model, [' -b ' num2str(Pb)] );
    
else
    if ~isempty(termination)
        model = svmtrain(TS_label, TS_inst_sc, [' -t ' num2str(kernel)  ' -c ' num2str(C, '%12.12f') ' -g ' num2str(gamma, '%12.12f') ' -e ' num2str(termination, '%12.12f') ]);
    else
        model = svmtrain(TS_label, TS_inst_sc, [' -t ' num2str(kernel)  ' -c ' num2str(C, '%12.12f') ' -g ' num2str(gamma, '%12.12f') ]);
    end
    [predict, accuracy(:,1)] = svmpredict(VS_label, VS_inst_sc, model);
    prob_tmp = [];
end

output_fold.predict = predict;
output_fold.accuracy = accuracy;
output_fold.prob_tmp = prob_tmp;
output_fold.model = model;

% fid = fopen('LOSO_log.txt','a');
% fprintf(fid, 'fold completed!\n')
% fclose(fid)
                        
% job = task.Parent;
% numTasksExecuted = get(job, 'UserData');
% numTasksExecuted = numTasksExecuted + 1;
% set(job, 'UserData', numTasksExecuted);
       
        